/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.vseclogs;

import com.ibm.hwmca.base.logd.LogDisplayerLaunch;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.base.vseclogs.E4LogsInterface;
import com.ibm.hwmca.base.vseclogs.E4MessageText;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.E4EventLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.LogBlock;
import com.ibm.hwmca.fw.log.LogEntryId;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.DateTimePattern;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class E4Logs {
    private static final String TRACE_MASKT = "VE4LLOGT";
    private static final String TRACE_MASKF = "VE4LLOGF";
    private static final String TRACE_MASKD = "VE4LLOGD";
    private static final String E4_TRM_FILE_NAME = "iqyye4.trm";
    private static final String DEFAULT_E4_DISPLAYER = "com.ibm.hwmca.base.logd.HexExpanderTasklet";
    public static final String E4_DETAILS_TITLE = "e4.details.title";
    private static final BaseMessageTitle detailsTitle = new BaseMessageTitle("e4.details.title");
    private ArrayList msgIdList = new ArrayList();
    private HashMap msgDisplayerMap = new HashMap();
    private HashMap msgTextMap = new HashMap();
    private String savedFileName = null;

    public E4Logs(E4LogsInterface e4Data) {
        try {
            this.parseTRM();
            e4Data.cfgLoaded = true;
        }
        catch (HException e) {
            e4Data.cfgLoaded = false;
            e4Data.cfgException = e;
        }
    }

    private void parseTRM() throws HException {
        String trmPath = null;
        int iMsgId = 0;
        String displayerClass = null;
        String sMsgId = null;
        try {
            trmPath = BaseFileControl.getFilePath(E4_TRM_FILE_NAME);
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKT, "got exception resolving trm file path:" + e);
            throw e;
        }
        if (trmPath == null) {
            Trace.trace(TRACE_MASKT, "trmPath is null!");
            throw new HException("path to iqyye4.trm is null");
        }
        Trace.trace(TRACE_MASKD, "trmPath is " + trmPath);
        try {
            BufferedReader br = new BufferedReader(new FileReader(trmPath + E4_TRM_FILE_NAME));
            char[] buffer = new char[8];
            String inline = null;
            byte[] bytes = new byte[4];
            while ((inline = br.readLine()) != null) {
                if (inline.length() < 4) continue;
                iMsgId = Character.digit(inline.charAt(0), 16) * 4096 + Character.digit(inline.charAt(1), 16) * 256 + Character.digit(inline.charAt(2), 16) * 16 + Character.digit(inline.charAt(3), 16);
                this.msgIdList.add(new Integer(iMsgId));
                displayerClass = inline.length() == 4 || inline.indexOf("*") != -1 ? new String(DEFAULT_E4_DISPLAYER) : new String(inline.substring(4).trim());
                Trace.trace(TRACE_MASKD, "displaying 0x" + Integer.toString(iMsgId, 16) + " with " + displayerClass);
                this.msgDisplayerMap.put(new Integer(iMsgId), displayerClass);
            }
            br.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKT, "got IOException parsing TRM file:" + e);
            throw new HException(e);
        }
        Iterator iter = this.msgIdList.iterator();
        BaseMessageText msgIdText = null;
        while (iter.hasNext()) {
            try {
                iMsgId = (Integer)iter.next();
                sMsgId = Integer.toString(iMsgId, 16).toUpperCase();
                if (sMsgId.length() == 1) {
                    sMsgId = "000" + sMsgId;
                } else if (sMsgId.length() == 2) {
                    sMsgId = "00" + sMsgId;
                } else if (sMsgId.length() == 3) {
                    sMsgId = "0" + sMsgId;
                }
                msgIdText = new BaseMessageText("XE4" + sMsgId);
                String x = msgIdText.toString();
                Trace.trace(TRACE_MASKD, "displaying " + sMsgId + "(" + iMsgId + ") as " + msgIdText);
                this.msgTextMap.put(new Integer(iMsgId), msgIdText);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKT, "got exception building msgTextMap:" + e);
                throw new HException(e);
            }
        }
    }

    public void getMsgIdData(E4LogsInterface interfaceBlock) {
        interfaceBlock.msgIdList = this.msgIdList;
        interfaceBlock.msgTextMap = this.msgTextMap;
    }

    public void getLogs(E4LogsInterface interfaceBlock) throws HException {
        Trace.trace(TRACE_MASKD, "--> getLogs()");
        if (interfaceBlock.command == 1) {
            this.savedFileName = interfaceBlock.fileName == null || interfaceBlock.fileName.equals("") ? new String("e4") : new String("!" + interfaceBlock.fileName);
        } else if (this.savedFileName == null) {
            this.savedFileName = new String("e4");
        }
        try {
            LogEntryId searchKey;
            Trace.trace(TRACE_MASKD, "log retrieval (" + this.savedFileName + ") started:" + DateFormat.getTimeInstance(1).format(new Date(System.currentTimeMillis())));
            Log[] oldLogs = null;
            Log[] newLogs = null;
            int numNewLogs = 0;
            int numOldLogs = 0;
            if (interfaceBlock.command == 1) {
                oldLogs = Log.retrieve(new LogEntryId(this.savedFileName, 0, 0, 0, null), 20L, 16384L);
                this.traceLogs(new LogEntryId(this.savedFileName, 0, 0, 0, null), oldLogs, "open/last");
                if (oldLogs.length == 0) {
                    interfaceBlock.numLogs = 0;
                    Trace.trace(TRACE_MASKD, "<-- getLogs(): empty log");
                    return;
                }
                numOldLogs = oldLogs.length - 1;
                numNewLogs = 1;
                newLogs = new Log[]{oldLogs[0]};
            } else if (interfaceBlock.command == 4) {
                oldLogs = Log.retrieve(interfaceBlock.logList[interfaceBlock.numLogs - 1].getLogEntryId(), 21L, 8192L);
                this.traceLogs(interfaceBlock.logList[interfaceBlock.numLogs - 1].getLogEntryId(), oldLogs, "get_earlier old/earlier");
                if (oldLogs.length == 0) {
                    numOldLogs = 0;
                    numNewLogs = 20;
                } else {
                    numOldLogs = oldLogs.length - 1;
                    numNewLogs = 20 - numOldLogs;
                }
                if (numNewLogs == 1) {
                    newLogs = new Log[]{oldLogs[0]};
                } else if (numNewLogs > 1) {
                    newLogs = Log.retrieve(interfaceBlock.logList[interfaceBlock.numLogs - 1].getLogEntryId(), numNewLogs, 32768L);
                    this.traceLogs(interfaceBlock.logList[interfaceBlock.numLogs - 1].getLogEntryId(), newLogs, "get_earlier new/later");
                    numNewLogs = newLogs.length;
                }
                if (numNewLogs == 0 && numOldLogs == 0) {
                    interfaceBlock.numLogs = 0;
                    Trace.trace(TRACE_MASKD, "<-- getLogs(): empty log");
                    return;
                }
            } else if (interfaceBlock.command == 2) {
                newLogs = Log.retrieve(interfaceBlock.logList[0].getLogEntryId(), 21L, 32768L);
                this.traceLogs(interfaceBlock.logList[0].getLogEntryId(), newLogs, "get_later new/later");
                numNewLogs = newLogs.length;
                numOldLogs = 20 - numNewLogs;
                if (numOldLogs > 0) {
                    oldLogs = Log.retrieve(interfaceBlock.logList[0].getLogEntryId(), numOldLogs + 1, 8192L);
                    this.traceLogs(interfaceBlock.logList[0].getLogEntryId(), oldLogs, "get_later old/earlier");
                    numOldLogs = oldLogs.length - 1;
                }
                if (numNewLogs == 0) {
                    if (oldLogs.length == 0) {
                        interfaceBlock.numLogs = 0;
                        Trace.trace(TRACE_MASKD, "<-- getLogs(): empty log");
                        return;
                    }
                    numNewLogs = 1;
                    newLogs = new Log[]{oldLogs[0]};
                }
            } else if (interfaceBlock.command == 32) {
                searchKey = new LogEntryId(this.savedFileName, 0, 0, (short)Integer.parseInt(interfaceBlock.searchKey), interfaceBlock.logList[interfaceBlock.index].getLogEntryId().getTimestamp(), interfaceBlock.logList[interfaceBlock.index].getLogEntryId().getOffset());
                oldLogs = Log.retrieve(searchKey, 20L, 12288L);
                this.traceLogs(searchKey, oldLogs, "search_earlier old/earlier");
                if (oldLogs.length == 0) {
                    interfaceBlock.numLogs = 0;
                    Trace.trace(TRACE_MASKD, "<-- getLogs(): search key not found earlier");
                    return;
                }
                numOldLogs = oldLogs.length - 1;
                numNewLogs = 20 - numOldLogs;
                if (numNewLogs == 1) {
                    newLogs = new Log[]{oldLogs[0]};
                } else if (numNewLogs > 1) {
                    newLogs = Log.retrieve(oldLogs[0].getLogEntryId(), numNewLogs, 32768L);
                    this.traceLogs(oldLogs[0].getLogEntryId(), newLogs, "search_earlier new/later");
                    numNewLogs = newLogs.length;
                }
            } else if (interfaceBlock.command == 16) {
                searchKey = new LogEntryId(this.savedFileName, 0, 0, (short)Integer.parseInt(interfaceBlock.searchKey), interfaceBlock.logList[interfaceBlock.index].getLogEntryId().getTimestamp(), interfaceBlock.logList[interfaceBlock.index].getLogEntryId().getOffset());
                newLogs = Log.retrieve(searchKey, 20L, 49152L);
                this.traceLogs(searchKey, newLogs, "search_later new/later");
                if (newLogs.length == 0) {
                    interfaceBlock.numLogs = 0;
                    Trace.trace(TRACE_MASKD, "<-- getLogs(): search key not found later");
                    return;
                }
                numNewLogs = newLogs.length;
                numOldLogs = 20 - numNewLogs;
                if (numOldLogs > 0) {
                    oldLogs = Log.retrieve(newLogs[0].getLogEntryId(), numOldLogs + 1, 8192L);
                    this.traceLogs(newLogs[0].getLogEntryId(), oldLogs, "search_later old/earlier");
                    numOldLogs = oldLogs.length - 1;
                }
            } else if (interfaceBlock.command == 8) {
                oldLogs = Log.retrieve(new LogEntryId(this.savedFileName, 0, 0, 0, interfaceBlock.time), 20L, 8192L);
                this.traceLogs(new LogEntryId(this.savedFileName, 0, 0, 0, interfaceBlock.time), oldLogs, "new_time old/earlier");
                if (oldLogs.length == 0) {
                    numOldLogs = 0;
                    numNewLogs = 20;
                } else {
                    numOldLogs = oldLogs.length - 1;
                    numNewLogs = 20 - numOldLogs;
                }
                if (numNewLogs == 1) {
                    newLogs = new Log[]{oldLogs[0]};
                } else if (numNewLogs > 1) {
                    if (numOldLogs == 0) {
                        newLogs = Log.retrieve(new LogEntryId(this.savedFileName, 0, 0, 0, interfaceBlock.time), 20L, 32768L);
                        this.traceLogs(new LogEntryId(this.savedFileName, 0, 0, 0, interfaceBlock.time), newLogs, "new_time new/later");
                    } else {
                        newLogs = Log.retrieve(oldLogs[0].getLogEntryId(), numNewLogs, 32768L);
                        this.traceLogs(oldLogs[0].getLogEntryId(), newLogs, "new_time new/later");
                    }
                    numNewLogs = newLogs.length;
                }
            }
            Trace.trace(TRACE_MASKD, "log retrieval done:" + DateFormat.getTimeInstance(1).format(new Date(System.currentTimeMillis())));
            if (numNewLogs > 0) {
                int i = newLogs.length - 1;
                while (i > 0) {
                    interfaceBlock.logList[newLogs.length - 1 - i] = newLogs[i];
                    --i;
                }
                if (numNewLogs <= 20) {
                    interfaceBlock.logList[newLogs.length - 1] = newLogs[0];
                }
            }
            int i = 1;
            while (i <= numOldLogs) {
                interfaceBlock.logList[numNewLogs + i - 1] = oldLogs[i];
                ++i;
            }
            interfaceBlock.numLogs = numNewLogs + numOldLogs;
            if (interfaceBlock.numLogs > 0) {
                interfaceBlock.eofFlag = 0;
                oldLogs = Log.retrieve(new LogEntryId(this.savedFileName, 0, 0, 0, null), 1L, 4096L);
                if (oldLogs.length != 1) {
                    // empty if block
                }
                if (oldLogs[0].getLogEntryId().equals(interfaceBlock.logList[interfaceBlock.numLogs - 1].getLogEntryId())) {
                    interfaceBlock.eofFlag = (short)(interfaceBlock.eofFlag | 1);
                }
                if ((oldLogs = Log.retrieve(new LogEntryId(this.savedFileName, 0, 0, 0, null), 1L, 16384L)).length != 1) {
                    // empty if block
                }
                if (oldLogs[0].getLogEntryId().equals(interfaceBlock.logList[0].getLogEntryId())) {
                    interfaceBlock.eofFlag = (short)(interfaceBlock.eofFlag | 2);
                }
            }
        }
        catch (HException e) {
            Trace.trace(TRACE_MASKD, "exception caught while reading logs: " + e);
            throw e;
        }
        Trace.trace(TRACE_MASKD, "numLogs=" + interfaceBlock.numLogs);
        this.extractDisplayData(interfaceBlock);
        int currSize = Log.getSize(this.savedFileName);
        int maxSize = Log.getMaxSize(this.savedFileName);
        Trace.trace(TRACE_MASKD, "csize:" + Integer.toString(currSize) + ":msize:" + Integer.toString(maxSize));
        interfaceBlock.percentFull = (short)((float)currSize / (float)maxSize * 100.0f);
        Trace.trace(TRACE_MASKD, "<-- getLogs()");
    }

    private void traceLogs(LogEntryId key, Log[] logs, String prefix) {
        DateFormat df = DateFormat.getDateInstance(3);
        DateFormat tf = DateTimePattern.getTimeWithMillisecondsPattern(Locale.getDefault());
        if (key.getTimestamp() == null) {
            Trace.trace(TRACE_MASKD, "traceLog key: no time specified");
        } else {
            Trace.trace(TRACE_MASKD, "traceLog key: user=0x" + Integer.toString(key.getUser(), 16) + ",time=" + df.format(key.getTimestamp()) + " " + tf.format(key.getTimestamp()));
        }
        if (logs.length == 0) {
            Trace.trace(TRACE_MASKD, "traceLog (" + prefix + "): no logs");
        } else if (logs.length == 1) {
            Trace.trace(TRACE_MASKD, "traceLog (" + prefix + "): one log: user=0x" + Integer.toString(logs[0].getUser(), 16) + ",time=" + df.format(logs[0].getTimestamp()) + " " + tf.format(logs[0].getTimestamp()));
        } else {
            Trace.trace(TRACE_MASKD, "traceLog (" + prefix + "): log 0 (first log): user=0x" + Integer.toString(logs[0].getUser(), 16) + ",time=" + df.format(logs[0].getTimestamp()) + " " + tf.format(logs[0].getTimestamp()));
            Trace.trace(TRACE_MASKD, "traceLog (" + prefix + "): log " + (logs.length - 1) + " (last log): user=0x" + Integer.toString(logs[logs.length - 1].getUser(), 16) + ",time=" + df.format(logs[logs.length - 1].getTimestamp()) + " " + tf.format(logs[logs.length - 1].getTimestamp()));
        }
    }

    private void extractDisplayData(E4LogsInterface interfaceBlock) {
        interfaceBlock.logTimestampList = new Date[interfaceBlock.numLogs];
        interfaceBlock.logTextList = new String[interfaceBlock.numLogs];
        int i = 0;
        while (i < interfaceBlock.numLogs) {
            interfaceBlock.logTimestampList[i] = interfaceBlock.logList[i].getTimestamp();
            E4EventLog e4elog = new E4EventLog(interfaceBlock.logList[i]);
            interfaceBlock.logTextList[i] = e4elog.getEventText().toString();
            if (e4elog.getEventDetailsText() != null) {
                interfaceBlock.logTextList[i] = "*" + interfaceBlock.logTextList[i];
            }
            ++i;
        }
    }

    public void displayLog(PanelTasklet tasklet, PanelTaskletResponse response, E4LogsInterface interfaceBlock) throws TaskletException {
        Trace.trace(TRACE_MASKD, "--> displayLog()");
        Log log = interfaceBlock.logList[interfaceBlock.index];
        LogBlock logBlock = log.getLogBlock((byte)-48);
        if (logBlock == null) {
            response.noAction();
            Trace.trace(TRACE_MASKD, "<-- displayLog(): no details");
            return;
        }
        if (log.getLogBlock((byte)-13) != null) {
            Trace.trace(TRACE_MASKF, "displaying with messageBox");
            MessageText[] mtDetails = new MessageText[]{new E4MessageText(new E4EventLog(log).getEventDetailsText())};
            Trace.trace(TRACE_MASKF, "   detailsTitle=[" + detailsTitle + "]");
            Trace.trace(TRACE_MASKF, "   mtDetails=[" + mtDetails + "]");
            Trace.trace(TRACE_MASKF, "   mtDetails[0]=[" + mtDetails[0] + "]");
            tasklet.showMessageBox(true, detailsTitle, mtDetails, "        I", MsgType.INFORMATION_MESSAGE, null);
            response.noAction();
        } else {
            Integer eventid = new Integer(log.getUser());
            String displayerClass = null;
            if (interfaceBlock.cfgLoaded) {
                displayerClass = (String)this.msgDisplayerMap.get(eventid);
                if (displayerClass == null) {
                    displayerClass = new String(DEFAULT_E4_DISPLAYER);
                }
            } else {
                displayerClass = new String(DEFAULT_E4_DISPLAYER);
            }
            Trace.trace(TRACE_MASKD, "displaying " + eventid + " with " + displayerClass);
            LogDisplayerLaunch ldl = new LogDisplayerLaunch(log, response);
            ldl.launchSubtasklet(logBlock, displayerClass);
        }
        Trace.trace(TRACE_MASKD, "<-- displayLog()");
    }
}

